const express = require('express');
const app     = express();
const bp      = require('body-parser');
const path    = require('path')

// Socket Requirements
const http    = require('http');
const socketio= require('socket.io');
const server  = http.createServer(app);
const io      = socketio(server); 
app.io = io;
// Controlers

const _p      = require('../src/utils/promise_error');
const  {Database}   = require('../src/utils/Database');
let    db = new Database();

const accounts   = require('./controlers/accounts');
const signup  = require('./controlers/signup');
const signin   = require('./controlers/signin');
const purchase   = require('./controlers/purchase');
const manufacturing   = require('./controlers/manufacturing');
const sales   = require('./controlers/sales');
const inventory   = require('./controlers/inventory');
const hrpayroll   = require('./controlers/hrpayroll');
const administration   = require('./controlers/administration');
const service   = require('./controlers/service');
const public   = require('./controlers/public');
 

// Middlewares
const auth    = require('./middlewares/auth');
const cros    = require('./middlewares/cros');
const errh    = require('./middlewares/error_handler');
const  {checkAuth}  = require('./checksuthforsoket')
app.use(cros);
app.use(bp.json());
app.use(public);
app.use('/api',auth);

app.use('',express.static(`uploads`));

// For Offline
const customDir = 'C:\\Users\\software';
const indexHtmlPath = path.join(customDir, 'index.html');

// Serve static files from the custom directory
app.use(express.static(customDir));

// Serve the index.html file for any other routes
app.get('', (req, res) => {
  res.sendFile(indexHtmlPath);
});


//

app.use(accounts);
app.use(signin);
app.use(signup);
app.use(purchase);
app.use(sales);
app.use(manufacturing);
app.use(hrpayroll);
app.use(administration); 
app.use(inventory);
app.use(service);

app.use(errh);

const _PORT = process.env.PORT || 5000;  
server.listen(_PORT,()=>{
    console.log(`Api is Running on port... ${_PORT}`)
});