const router = require('express').Router();
const _p      = require('../utils/promise_error');
const path    = require('path')
const fs = require('fs')
const multer = require("multer")
const  {getCurrentISODT,isoFromDate,isoToDate} = require('../utils/functions')
const  {Database}   = require('../utils/Database');
const  {Transaction}   = require('../utils/TranDB');
const config =   require('../config.json');
// const axios = require('axios')
const FormData = require('form-data');
const {generate}      = require('../utils/passwords');
const tokenSession      = require('../utils/token_session');
const  {getStock,itemCostUpdate,stockUpdate}   = require('../models/stock');
// For Backup
const  dbConfig   = require('../utils/dbConfig');
const mysqldump = require('mysqldump');
// End 

let    db = new Database();
let    Tran = new Transaction();

let getSalesOrderInv = async (req,res,next)=>{
    let [saleError,sale] =  await _p(db.query(`select sale_o_id  from tbl_sales_order_master  order by sale_o_id  desc LIMIT 1`)).then(result=>{
        return result;
    });
    if(saleError){
        next(saleError)
    }
    let saleCode = '';
    if(sale.length == 0){
        saleCode = 'SO1';
    }else{
        saleCode = 'SO'+(parseFloat(sale[0].sale_o_id)+1);
    }
    return new Promise((resolve,reject)=>{
             resolve(saleCode)
    })
}


router.get(`/public/get-products`, async (req, res, next) => {
    let clauses = ` `;
    
    // If itemId is provided, add a condition for filtering by itemId
    if (req.query.productId != undefined) {
        clauses = ` and it.item_id = '${req.query.productId}' `;
    }

    if (req.query.categoryId != undefined) {
        clauses = ` and it.category_id = '${req.query.categoryId}' `;
    }

    // Get pagination parameters from request, with default values for page and pageSize
    const page = parseInt(req.query.page) || 1;         // Default to page 1
    const pageSize = parseInt(req.query.pageSize) || 10; // Default to 10 items per page
    const offset = (page - 1) * pageSize;               // Calculate offset

    // Run the query with LIMIT and OFFSET for paging
    let [itemsErr, items] = await _p(db.query(`
        SELECT it.*, acc.acc_name, gp.group_name, ct.category_name,
            ut.unit_name, ut.unit_symbol, ut.base_unit_id,
            (
                SELECT unit_symbol FROM tbl_item_units WHERE unit_id = ut.base_unit_id
            ) as base_unit_name,
            m.model_name,
            ori.origin_name
        FROM tbl_items it
        LEFT JOIN tbl_accounts acc ON acc.acc_id = it.tax_acc_id
        LEFT JOIN tbl_groups gp ON gp.group_id = it.group_id
        LEFT JOIN tbl_categories ct ON ct.category_id = it.category_id
        LEFT JOIN tbl_models m ON m.model_id = it.model_id
        LEFT JOIN tbl_origins ori ON ori.origin_id = it.origin_id
        LEFT JOIN tbl_item_units ut ON ut.unit_id = it.unit_id
        WHERE 
            it.status = "a"  
            AND find_in_set(?, it.branch_ids)    
            ${clauses}
        ORDER BY it.item_id DESC
        LIMIT ? OFFSET ?
    `, [1, pageSize, offset]).then(res => {
        return res;
    }));

    if (itemsErr && !items) return next(itemsErr);

    // Get the total count of items for pagination info
    let [totalCountErr, totalCount] = await _p(db.query(`
        SELECT COUNT(*) as count
        FROM tbl_items it
        WHERE it.status = "a" AND find_in_set(?, it.branch_ids) ${clauses}
    `, [1]).then(res => res[0].count));

    if (totalCountErr) return next(totalCountErr);

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / pageSize);

    // Send response with pagination details
    res.json({
        items,
        page,
        pageSize,
        totalPages,
        totalCount
    });
});

router.post(`/public/customer-auth-check`,async(req,res,next)=>{
    let [checkExistErr,checkExist] =  await _p(db.query(`select acc.acc_id,acc.acc_name,acc.contact_no,acc.address
        from tbl_accounts acc
        where 
        acc.status = "a"
        and acc.contact_no = ?
        and acc.pass = ?
        `,[req.body.contactNo,req.body.pass]).then(res=>{
           return res;
       }));
       
       var auth = false
       if(checkExist.length != 0){
        auth = true
        }
        
        let data = checkExist.legth != 0 ? checkExist : null
   
       res.json({auth,info : data});
})


router.post('/public/create-customer-order',async(req,res,next)=>{  
    let para = req.body;
        let masterData = para.masterData;
        let customer = para.customer;
    // Create General Supplier or New Supplier - Start
    if(customer.acc_id == 'G' || customer.acc_id == 'N'){
       
        let [existsErr,exists] =  await _p(db.countRows(`select acc_name from tbl_accounts where acc_name = ? and branch_id = ? and party_type!='general'  and status = 'a' `,[customer.acc_name,1])).then(res=>{
            return res;
        });
        if(exists > 0 ){
            res.json({
                error:true,
                message:`Customer name already exists.`
            });
            return false
        }
        
        let customerData = {
            acc_name:customer.acc_name,
            acc_type_id:'debitor',
            acc_type_name:'Customer',
            acc_type_label:'Customer',
            institution_name:customer.institution_name,
            address:customer.address,
            contact_no:customer.contact_no,
            creation_date : masterData.creation_date,
            party_type: customer.acc_id =='G'?'general':'no',
            branch_id: 1,
            create_by: 1,
            pass: customer.pass,
        }
        let [cusEntyErr,cusEnty] =  await _p(db.insert('tbl_accounts',customerData)).then((row)=>{
            return row;
        })
        masterData.acc_id = cusEnty.insertId;
    }else{
        masterData.acc_id = customer.acc_id;
    }

    // Create General Supplier or New Supplier - End

    // Save Master Data - Start
        masterData.sale_order_no = await  getSalesOrderInv(req,res,next);
        masterData.created_by   = 1;  
        masterData.branch_id    = 1;

        let [masterEnrtyErr,masterEnrty] =  await _p(db.insert('tbl_sales_order_master',masterData)).then((row)=>{
            return row;
        });

    // Save Master Data - End

    // Save Detail Data - Start
        para.itemCart.map(async(item)=>{
            let cartData = {
                sale_o_id: masterEnrty.insertId,
                serials: item.serials != null || item.serials != undefined ? Array.prototype.map.call(item.serials, function(serial) { return serial.serial_number; }).join(",") : '',
                item_id: item.item_id,
                per_unit_id: item.per_unit_id,
                warehouse_id: item.warehouse_id,
                item_qty: item.item_qty,
                item_tax: item.item_tax,
                tax_acc_id: item.tax_acc_id,
                item_discount: item.item_discount,
                item_discount_per: item.item_discount_per,
                item_rate: item.item_rate,
                item_total: item.item_total,
                discount_acc_id: item.discount_acc_id,
                item_tax_per: item.item_tax_per,
                sale_qty: item.sale_qty,
                sale_rate: item.sale_rate,
                retail_qty: item.retail_qty,
                created_date : masterData.created_date,
                branch_id: 1,
            }
            await _p(db.insert('tbl_sales_order_details',cartData)).then((row)=>{
                return row;
            });

            // Save Serial Data - start
            item.serials.map(async(serial)=>{
                let serialData = {
                    serial_number: serial.serial_number,
                    item_id: item.item_id,
                    status: 'ordered',
                    branch_id: 1,
                }
                await _p(db.insert('tbl_item_serials',serialData)).then((row)=>{
                    return row;
                });
            })
            // Save Serial End - start

        // Save Detail Data - End
        });
    

    res.json({error:false,message:' order created Successfully.',sale_o_id: masterEnrty.insertId,customerId :  masterData.acc_id});
});


router.post('/public/get-order-record-with-details',async(req,res,next)=>{  
    let para = req.body;
    let cluases = ``

    if(para.customerId != undefined && para.customerId != null){
        cluases += ` and som.acc_id = ${para.customerId} `
    }
    if(para.userId != undefined && para.userId != null){
        cluases += ` and som.created_by = ${para.userId} `
    }

    if((para.fromDate != undefined && para.fromDate != null) && (para.toDate != undefined && para.toDate != null)){
        cluases += ` and som.created_date between '${para.fromDate}' and '${para.toDate}' `
    }




    if(para.sale_o_id != undefined && para.sale_o_id != null &&  para.sale_o_id != 0){
        cluases += ` and som.sale_o_id = ${para.sale_o_id} `
    }

    if( para.sale_o_id == null && para.from =='voucher'){
        cluases += `  order by som.sale_o_id desc limit 1 `
    }else{
        cluases += ` order by som.sale_o_id desc `
    }



    let [masterDataErr,masterData] =  await _p(db.query(`select som.*,acc.acc_code,acc.acc_name,acc.institution_name,acc.address,acc.contact_no,
             discount_acc.acc_name as discount_acc_name,tax_acc.acc_name as tax_acc_name,transport_acc.acc_name as transport_acc_name,u.user_full_name
            from tbl_sales_order_master som
            left join tbl_accounts acc on acc.acc_id = som.acc_id
            left join tbl_accounts discount_acc on discount_acc.acc_id = som.discount_acc_id
            left join tbl_accounts tax_acc on tax_acc.acc_id = som.tax_acc_id
            left join tbl_accounts transport_acc on transport_acc.acc_id = som.transport_acc_id
            left join tbl_users u on u.user_id = som.created_by
            where  som.status != 'd' 
            and som.branch_id = ?  
            ${cluases}
           
             `,[1])).then(res=>{
        return res;
    });
    if(masterDataErr && !masterData){
      next(masterDataErr)
    }

   let data  =  masterData.map(async(detail)=>{ 
        let [itemDataErr,itemData] =  await _p(db.query(`select sod.*,it.item_name,it.is_serial,u.unit_name,u.unit_symbol,u.conversion,
            (
            select unit_symbol  from tbl_item_units   where unit_id = u.base_unit_id
            ) as base_unit_name,
            u.unit_id,u.base_unit_id,
            peru.unit_symbol as per_unit_symbol, 
            peru.conversion as per_conversion,
            pr.average_rate as purchase_average_rate,

            concat(it.item_name,' - ',it.item_barcode) as display_text,
            w.warehouse_name,
            discount_acc.acc_name as discount_acc_name,tax_acc.acc_name as tax_acc_name

            from tbl_sales_order_details sod
            left join tbl_warehouses w on w.warehouse_id  = sod.warehouse_id
            left join tbl_accounts discount_acc on discount_acc.acc_id = sod.discount_acc_id
            left join tbl_accounts tax_acc on tax_acc.acc_id = sod.tax_acc_id
            left join tbl_items it on it.item_id = sod.item_id
            left join tbl_item_units u on u.unit_id  = it.unit_id 
            left join tbl_item_units peru on peru.unit_id  = sod.per_unit_id 

            left join tbl_item_average_rate pr on pr.item_id =  sod.item_id and pr.branch_id = sod.branch_id
            
            where  sod.status != 'd'  
            and sod.sale_o_id = ? 
            `,[detail.sale_o_id])).then(res=>{
            return res;
           });



           
     // start for Muiltiple Unit 
      itemData =  itemData.map((item)=>{
        let unitOne = [{
            unit_symbol : item.unit_symbol,
            conversion : item.conversion,
            unit_id : item.unit_id
        }]

        let unitTwo = [{
            unit_symbol : item.base_unit_name,
            conversion : 1,
            unit_id : item.base_unit_id
        }]
 


        item.units = item.conversion > 1 ? unitOne.concat(unitTwo) : unitOne

        return item

      })

    // end for Muiltiple Unit 


          itemData =  itemData.map(async(item)=>{
              let [saleDataErr,saleData] =  await _p(db.query(` select ifnull(sum(item_qty),0) as done_item_qty,
                      ifnull(sum(retail_qty),0) as done_retail_qty,ifnull(sum(sale_qty),0) as done_sale_qty
                        from  tbl_sales_details 
                        where order_id = ? and item_id = ? and status='a'
                      `,[item.sale_o_id,item.item_id]).then(res=>{
                          return res
                      }));

                    item.done_item_qty =   saleData.length != 0? saleData[0].done_item_qty : 0;
                    item.done_retail_qty =   saleData.length != 0? saleData[0].done_retail_qty : 0;
                    item.done_sale_qty =   saleData.length != 0? saleData[0].done_sale_qty : 0;

                    return item;
           });

           


    detail.details = await  Promise.all(itemData)
    return detail;
    });

  
  

    res.json(await  Promise.all(data) );
});


router.get(`/public/get-product-categories`,async(req,res,next)=>{
    
    let [categoriesErr,categories] =  await _p(db.query(`select category_id,category_name 
     from tbl_categories 
     where 
     status = "a"  
     order by category_id   desc
     `,).then(res=>{
        return res;
    }))

    if(categoriesErr && !categories) return next(groupsErr);
    res.json(categories);
});

module.exports = router;