import { CustomValidator } from '../base';
import { ContextBuilder } from '../context-builder';
import * as Options from '../options';
import { Validators } from './validators';
export declare class ValidatorsImpl<Chain> implements Validators<Chain> {
    private readonly builder;
    private readonly chain;
    private lastValidator;
    private negateNext;
    constructor(builder: ContextBuilder, chain: Chain);
    private addItem;
    not(): Chain;
    withMessage(message: any): Chain;
    custom(validator: CustomValidator): Chain;
    exists(options?: {
        checkFalsy?: boolean;
        checkNull?: boolean;
    }): Chain;
    isArray(options?: {
        min?: number;
        max?: number;
    }): Chain;
    isString(): Chain;
    private addStandardValidation;
    contains(elem: any): Chain;
    equals(comparison: string): Chain;
    isAfter(date?: string): Chain;
    isAlpha(locale?: Options.AlphaLocale): Chain;
    isAlphanumeric(locale?: Options.AlphanumericLocale): Chain;
    isAscii(): Chain;
    isBase32(): Chain;
    isBase64(): Chain;
    isBefore(date?: string): Chain;
    isBoolean(): Chain;
    isByteLength(options: Options.MinMaxOptions): Chain;
    isCreditCard(): Chain;
    isCurrency(options?: Options.IsCurrencyOptions): Chain;
    isDataURI(): Chain;
    isDecimal(options?: Options.IsDecimalOptions): Chain;
    isDivisibleBy(number: number): Chain;
    isEmail(options?: Options.IsEmailOptions): Chain;
    isEmpty(options?: Options.IsEmptyOptions): Chain;
    isFQDN(options?: Options.IsFQDNOptions): Chain;
    isFloat(options?: Options.IsFloatOptions): Chain;
    isFullWidth(): Chain;
    isHalfWidth(): Chain;
    isHash(algorithm: Options.HashAlgorithm): Chain;
    isHexColor(): Chain;
    isHexadecimal(): Chain;
    isIdentityCard(locale: ['ES'] | 'any'): Chain;
    isIP(version?: Options.IPVersion): Chain;
    isIPRange(): Chain;
    isISBN(version?: number): Chain;
    isISSN(options?: Options.IsISSNOptions): Chain;
    isISIN(): Chain;
    isISO8601(options?: Options.IsISO8601Options): Chain;
    isISO31661Alpha2(): Chain;
    isISO31661Alpha3(): Chain;
    isISRC(): Chain;
    isIn(values: any[]): Chain;
    isInt(options?: Options.IsIntOptions): Chain;
    isJSON(): Chain;
    isJWT(): Chain;
    isLatLong(): Chain;
    isLength(options: Options.MinMaxOptions): Chain;
    isLowercase(): Chain;
    isMagnetURI(): Chain;
    isMACAddress(options?: Options.IsMACAddressOptions): Chain;
    isMD5(): Chain;
    isMimeType(): Chain;
    isMobilePhone(locale: Options.MobilePhoneLocale, options?: Options.IsMobilePhoneOptions): Chain;
    isMongoId(): Chain;
    isMultibyte(): Chain;
    isNumeric(options?: Options.IsNumericOptions): Chain;
    isPort(): Chain;
    isPostalCode(locale: Options.PostalCodeLocale): Chain;
    isRFC3339(): Chain;
    isSurrogatePair(): Chain;
    isURL(options?: Options.IsURLOptions): Chain;
    isUUID(version?: Options.UUIDVersion): Chain;
    isUppercase(): Chain;
    isVariableWidth(): Chain;
    isWhitelisted(chars: string | string[]): Chain;
    matches(pattern: RegExp | string, modifiers?: string): Chain;
}
