import { IBigFloat, NumericValue } from "./types";
export declare class BigFloat implements IBigFloat {
    exponent: number;
    coefficient: bigint;
    constructor(n: NumericValue);
    decimalPlaces(): number;
    isInteger(): boolean;
    isNegative(): boolean;
    isPositive(): boolean;
    isZero(): boolean;
    toString(): string;
    equals(y: NumericValue): boolean;
    greaterThan(y: NumericValue): boolean;
    greaterThanOrEqualTo(y: NumericValue): boolean;
    lessThan(y: NumericValue): boolean;
    lessThanOrEqualTo(y: NumericValue): boolean;
    absoluteValue(): BigFloat;
    negated(): BigFloat;
    squareRoot(): BigFloat;
    dividedBy(y: NumericValue): BigFloat;
    minus(y: NumericValue): BigFloat;
    plus(y: NumericValue): BigFloat;
    times(y: NumericValue): BigFloat;
    toPower(y: NumericValue): BigFloat;
    ceil(): BigFloat;
    floor(): BigFloat;
    dp: () => number;
    isNeg: () => boolean;
    eq: (y: NumericValue) => boolean;
    gt: (y: NumericValue) => boolean;
    gte: (y: NumericValue) => boolean;
    lt: (y: NumericValue) => boolean;
    lte: (y: NumericValue) => boolean;
    isInt: () => boolean;
    isPos: () => boolean;
    abs: () => BigFloat;
    neg: () => BigFloat;
    sqrt: () => BigFloat;
    div: (y: NumericValue) => BigFloat;
    sub: (y: NumericValue) => BigFloat;
    add: (y: NumericValue) => BigFloat;
    mul: (y: NumericValue) => BigFloat;
    pow: (y: NumericValue) => BigFloat;
}
