"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.is_integer = exports.is_zero = exports.is_positive = exports.is_negative = exports.is_number = exports.is_big_float = void 0;
const constants_js_1 = require("./constants.js");
const constructors_js_1 = require("./constructors.js");
const relational_js_1 = require("./relational.js");
function is_big_float(big) {
    return (typeof big === "object"
        && typeof big.coefficient === "bigint"
        && Number.isSafeInteger(big.exponent));
}
exports.is_big_float = is_big_float;
function is_number(token) {
    return !Number.isNaN(Number(token));
}
exports.is_number = is_number;
function is_negative(big) {
    return big.coefficient < constants_js_1.BIGINT_ZERO;
}
exports.is_negative = is_negative;
function is_positive(big) {
    return big.coefficient >= constants_js_1.BIGINT_ZERO;
}
exports.is_positive = is_positive;
function is_zero(big) {
    return big.coefficient === constants_js_1.BIGINT_ZERO;
}
exports.is_zero = is_zero;
function is_integer(a) {
    return relational_js_1.eq(a, constructors_js_1.integer(a));
}
exports.is_integer = is_integer;
